#! /usr/bin/python
# -*- coding: utf-8 -*-
'''
Ten plik zawiera przykłady lub szablony rejestracji wtyczek za pomocą gimpfu.register (). 
Jest to przeznaczone dla programistów Pythona GIMP, a nie użytkowników. 
Kiedy zainstalujemy, ??ten pojedynczy plik umieszcza wiele demo wtyczek (siedem) w GIMP-ie. 
Wtyczki demo zrobią wiele z wyjątkiem zrobienia wyglądu.

Pokazują one różne kombinacje: 
- gdzie pojawi się (lub nie) wtyczka w menu (lub gdzie indziej) w GIMP-ie 
- gdy elementy menu wtyczki są włączone 
- jakie parametry wtyczka przyjmuje do plugin_main () 
- czy wtyczka otwiera okno GUI dla użytkownika, aby mógł wybrać opcje (ustawianie parametrów.)

Korzystanie z modułu gimpfu Python GIMP jest prostsze niż rejestracja wtyczki 
za pomocą procedur GIMP PDB (np.  gimp.pdb.gimp_install_procedure()). 
Ale oszałamiające jest wiele kombinacji.
Ten plik sprawia że możemy przetestować wiele wtyczek, gdy ten plik jest 
zainstalowany w katalogu lokalnym. 
Wtyczki są rozrzucone w różnych miejscach GIMP GUI.
Wtyczki mają nazwy plugin_1 do plugin_6a
(Należy jednak pamiętać, że Przeglądarka poda jakie wtyczka przyjmuje 
parametry run-mode , GIMP Python ukrywa jednak  parametr czyli nie 
przekazuje go do wtyczki, ale zamiast tego: może wyświetlić okno dialogowe, 
może pobierać ostatnie argumenty i przekazuje do Naszej wtyczki prawidłowy 
zestaw argumentów pod dyktando run-mode.)
Przeszukaj !!! Aby zobaczyć istotne różnice pomiędzy tymi wtyczkami.

Copyright 2010 Lloyd Konneker

Modyfikacja i tłumaczenie wtyczki 30.05.2015, Zbigniew Małach 

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
'''

from gimpfu import *


'''
Tworzy nowe rozwijane menu na pasku okna GIMP o nazwie 
"Somewhere (Gdzieś)". Wtyczka pojawi się jako podmenu 
Somewhere - element z etykietą "plugin1..." otwierający 
okno dialogowe.
Pozycja podmenu jest wyświetlana jeśli jest otwarty jakiś obraz.
Gdy brak obrazu pozycja podmenu jest wyszarzona. 
Brak obrazu lub drawable jest przekazywany do wtyczki.

'''
def plugin_func1(args): # !!! Brak Image (obrazu) lub drawable
  gimp.pdb.gimp_message("Done")
  print  args  
              
register(
  "plugin_1_pdb",
  "To jest plugin_1", # Krótki opis działań wykonywanych przez 
	# wtyczkę, zobaczymy go po umieszczeniu wskaźnika myszki na nazwie punktu w menu.
  "help",  # Nazwa Dokumentacyjna, 
	# informacja o wtyczce, która pojawia się w Przeglądarce procedur, 
	# należy wyjaśniać w bardziej szczegółowy sposób, co Nasza wtyczka robi.
  "author",
  "copyright",
  "year",
  "plugin_1...",  # !!! Jeśli wtyczka otwiera okno dialogowe, 
  # standardowa Etykieta interfejsu GUI, ma dodany wielokropek (...).
  # Gdy brak obrazu pozycja podmenu jest wyszarzona.

  "*",
  [
      (PF_STRING, "arg", "Argument", "Wartości domyślne")
  ],
  [],
  plugin_func1, 
  menu="<Image>/Somewhere") # !!! Tworzy pozycja na pasku menu. 

'''
Pojawia się w menu "Filtry", Nie możemy zmienić pozycji wtyczki w menu, 
zawsze idą do dołu rozwijanej listy menu danego katalogu/podkatalogu.
Elementem menu będzie "plugin2"
Element menu jest dostępny tylko jeśli zostanie otwarty obraz.
Nie otwiera się okno dialogowe
Brak parametrów przekazywanych do wtyczki.
'''
def plugin_func2(): # !!! Brak parametrów Image lub drawable lub run-mode
  gimp.pdb.gimp_message("Done") # !!! To pojawia się tylko na pasku stanu,
  # w dole okna Edytora obrazów GIMP, a nie w oddzielnym oknie wiadomości ??
  print "2"

register(
  "plugin_2_pdb", 
  "To jest plugin_2",  # # Krótki opis działań wykonywanych przez 
	# wtyczkę, zobaczymy go po umieszczeniu wskaźnika myszki na nazwie punktu w menu.
  "help",
  "author",
  "copyright",
  "year",
  "plugin_2", # brak okna dialogowego, więc nie ma wielokropków...
  "*",    # !!! tylko aktywne, jeśli jest otwarty obraz
  [], # brak argumentów
  [],
  plugin_func2, 
  menu="<Image>/Filters/")
              
              
'''
Pojawi się w "Filtry => Rozmycie"
Element w menu otwierający okno dialogowe 
z etykietą "plugin3...". 
Menu jest aktywne, tylko jeśli jest otwarty obraz.
Otwiera się Okno dialogowe aby uzyskać "Argument".
Image i drawable są przekazywane do wtyczki.
'''
def plugin_func3(image, drawable, args):  
  # !!! Image i drawable są przekazywane do wtyczki, choć nie zadeklarowane w register()
  gimp.pdb.gimp_message("Done")
  print "3", args
  
register(
  "plugin_3_pdb",
  "To jest plugin_3",
  "help",
  "author",
  "copyright",
  "year",
  "<Image>/Filters/Blur/plugin_3...",
  "*",
  [
      (PF_STRING, "arg", "Argument", "Wartości domyślne")
  ],
  [],
  plugin_func3
  )


'''
Pojawi się w menu "Filtry" (zawsze na dole)
Element w menu otwierającym okno dialogowe 
z etykietą "plugin4...". 
Pozycja w menu jest aktywna nawet kiedy nie otwarto obrazu.
!!! Jeśli obraz nie jest otwarty, kiedy wywołamy wtyczkę,
zostanie otwarte okno dialogowe, aby uzyskać Image, drawable i "The argument".
Image i drawable są przekazywane do wtyczki.

!!! Prawdopodobnie tego nie chcemy.
Jeśli wtyczka potrzebuje obrazu, jeśli ustawić typ obrazu na "*" 
lub podobne wtyczka nie zostanie otwarta chyba że obraz był otwarty.
Jeśli wtyczka nie potrzebuje obrazu,
zamiast używać parametru słowa kluczowego menu="<Image>/Filtry/"
(i wziąć obraz i parametr drawable z plugin_func4())
tak że nie ma image i drawable są zawsze przekazywane.
'''
def plugin_func4(image, drawable, args):  
  # !!! obraz i drawable przekazywane do wtyczki choć nie zadeklarowane w register()
  gimp.pdb.gimp_message("Done")
  print "4", args
  
register(
  "plugin_4_pdb",
  "To jest plugin_4",
  "help",
  "author",
  "copyright",
  "year",
  "<Image>/Filters/plugin_4...",
  "",    # !!! Zawsze włączone, nawet jeśli nie ma otwartego obrazu.
  [
      (PF_STRING, "arg", "Argument", "Wartości domyślne")
  ],
  [],
  plugin_func4
  )


'''
Pojawia się w menu "Filtry" !!! w tej samej grupie co Python-Fu.
(Myślę że: kieruje do pozycji menu nazwanej grupy,
poszukaj w menu plików źródłowych GIMP/image-menu.xml.in dla nazwy "Placeholder".)
W menu element otwierający okno dialogowe 
z etykietą "plugin5...".
Pozycja w menu jest aktywna nawet kiedy nie otwarto obrazu.
Otwiera się Okno dialogowe aby uzyskać "The argument".
Image i drawable są przekazywane do wtyczki.

'''
def plugin_func5(args):  
  # !!! image lub drawable przekazywane
  gimp.pdb.gimp_message("Done")
  print "5", args
  '''
  !!! Wywołaj plugin_4 lub wykorzystaj istniejące opcje dla niego 
  i nie otwieraj dialogu dla plugin_4.
  
  !!! Oto napis "foo" musi być przekazany, lecz jest ignorowany przez plugin_4
  i plugin_4 korzysta z ostatnio wprowadzonego przez użytkownika napisu 
  lub domyślne (jeśli użytkownik nie uruchomił wcześniej w sesji plugin_4.)
  
  !!! Tutaj można używać podkreślenia, nie myślnika ponieważ gimpfu zmienia nazwy.
  Użyj Przeglądarki procedur aby zobaczyć że jest on zarejestrowany jako "python-fu-plugin-4-pdb".
  Uwaga: gimpfu dodaje prefixes "python-fu" (jeśli już nie istnieje) 
  choć w Pythonie używamy nazw z podkreśleniem zamiast myślnika,
  ale rzeczywiście instaluje je w PDB z myślnikami w nazwie.
  
  (Tutaj, przechodzi None do image i drawable ponieważ plugin_4 oczekuje ich,
  ale nie mamy jakiś aby przekazać je w tym przykładzie.)
  
  Można używać run-mode=RUN_NONINTERACTIVE.
  Następnie użył plugin_4 by przekazanych parametrów.
  '''
  gimp.pdb.python_fu_plugin_4_pdb( None, None, "foo", run_mode=RUN_WITH_LAST_VALS)
  
register(
  "plugin_5_pdb",
  "To jest plugin_5",
  "help",
  "author",
  "copyright",
  "year",
  "plugin_5...", 
  "",    # !!! zawsze włączone, nawet gdy obraz nie jest otwarty
  [
      (PF_STRING, "arg", "The argument", "default-value")
  ],
  [],
  plugin_func5,
  menu = "<Image>/Filters/Languages/" # !!! Languages wstawiają go w grupie menu
  # nie ma podmenu Languages (Języki)
  )


'''
Wtyczka "engine".
Nie pojawia się w żadnym menu.
Możemy utworzyć skrót klawiszowy do niej, lub wywołać z innej wtyczki.
Otwiera się okno dialogowe, aby uzyskać "The argument".
Brak Image i drawable są przekazywane do wtyczki.

Zauważymy, że nie pojawia się w Przeglądarce wtyczek.
Nie jest wyświetlana w Edycja => Skróty klawiszowe => Wtyczki> jako 'python-fu-plugin-6-PDB',
(w przeciwieństwie do innych wtyczek, które pojawiają się w Skróty klawiszowe,
NIE jest Etykietą menu wtyczki, ale nazwą Procedury PDB, gdzie sie pojawia.)
'''
def plugin_func6(args):
  # !!! Brak image i drawable są przekazywane do wtyczki
  gimp.pdb.gimp_message("Done")
  print "6", args
  
register(
  "plugin_6_pdb",
  "This is plugin_6",
  "help",
  "author",
  "copyright",
  "year",
  "",   # !!! nie pojawia się w żadnym menu
  "",   # !!! Jest dyskusyjna, ponieważ nie ma obecność w GUI, nie mogą być włączone / wyłączone
  [
      (PF_STRING, "arg", "The argument", "default-value")
  ],
  [],
  plugin_func6,
  # menu="<Image>"  # !!! Dyskusyjne, ponieważ element menu jest pusty, ale zachowuje image i drawable od przekazania
  )


'''
Wtyczka jest na pasku menu.
Image i drawable nie są przekazywane do wtyczki.

!!! Należy pamiętać, że czasami potrzeba dwóch kliknięć, aby uaktywnić tą wtyczkę
W rzeczywistości jest to podmenu do siebie.
Czasami pierwsze kliknięcie aktywuje podmenu (który ma tylko jeden element, który zostanie podświetlony.))
Drugie kliknięcie aktywuje menu i wywołuje wtyczkę.
W innych przypadkach (jeśli wcześniej została kliknięta jakaś pozycja na pasku menu)
przytrzymanie myszki nad pozycją podświetla ją a pierwsze kliknięcie uaktywnia ją.
Prawdopodobnie, jest to kaprys elementu gtk, gdy w pasku menu znajduje się Etykieta, 
który uruchamia menu rozwijane, czyli dwa osobne widgety, ale każdy z nich używa kliknięcie?
Z tego powodu, nie powiniśmy używać tego, aby nie mylić większość użytkowników:
bo "Klikam na nią i nic się nie dzieje."
'''
def plugin_func6b(args):
  # !!! image i drawable nie przekazywane do wtyczki
  gimp.pdb.gimp_message("Done")
  print "6b", args
  
register(
  "plugin_6b_pdb",
  "To jest plugin_6b",
  "help",
  "author",
  "copyright",
  "year",
  "Plugin6b...",   
  "*",    # !!! Wtyczka aktywna, jeśli jest otwarty dowolny typ obrazu
  [
      (PF_STRING, "arg", "Argument", "Wartości domyślne")
  ],
  [],
  plugin_func6b,
  menu="<Image>"  # !!! Podmenu nie jest tworzone
  # Etykieta pojawi się na głównym pasku menu GIMP.
  )


'''
main() jest zdefiniowane w gimpfu.  
Wywołuje gimp.main (), która wywołuje odpowiednie procedury PDB, aby zainstalować je do wtyczki.
'''
main()